﻿namespace Microsoft.Samples.PlanMyNight.Infrastructure
{
    using System;
    using System.ComponentModel.Composition.Hosting;

    /// <summary>
    /// This class provides the ambient container for this application.
    /// </summary>
    public static class ServiceLocator
    {
        private static Func<ExportProvider> currentProvider;

        /// <summary>
        /// The current ambient container.
        /// </summary>
        public static ExportProvider Current
        {
            get { return currentProvider(); }
        }

        /// <summary>
        /// Set the delegate that is used to retrieve the current container.
        /// </summary>
        /// <param name="newProvider">Delegate that, when called, will return
        /// the current ambient container.</param>
        public static void SetLocatorProvider(Func<ExportProvider> newProvider)
        {
            currentProvider = newProvider;
        }
    }
}
